package com.izenpe.zain.cliente.pades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class VerificacionFirmaPAdES {
	// Nombre del fichero cuya firma va a ser verificada.
	private static final String signName = "PruebaPDF-SignedPADES.pdf";

	public static void main(String args[]) {
		try {

			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil PDF en la peticin de Verificacin
			// de firma.
			smartVerifyReq.setProfile(Constants.Profile.PDF);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			// Datos a verificar.
			smartVerifyReq.setInputPdfBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/output/" + signName)));
			
//			smartVerifyReq.setAddSignatureType(true);
			
//			smartVerifyReq.setAddSignatureForm(true);

			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();

			// Se comprueba la validez de la respuesta de Verificacin de firma
			// PDF
			System.out.println("ResultMajor: " + smartVerifyResp.getResultMajor());
			System.out.println("ResultMinor: " + smartVerifyResp.getResultMinor());
			System.out.println("ResultMessage: " + smartVerifyResp.getResultMessage());
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				System.out.println("Verificando firma del tipo: " + smartVerifyResp.getSignature(0).getSignatureType());
				System.out.println("Verificando firma con formato: " + smartVerifyResp.getSignature(0).getSignatureForm());
				System.out.println("La firma ha sido verificada con xito.");
			} else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}